function out = fct_G_statistics(G)
    
    % STATISTICS    
        mean_mu = G.mu_vec'*G.g_vec;
        std_mu = sqrt(((G.mu_vec-mean_mu).^2)'*G.g_vec);
        min_mu = min(G.mu_vec);
        [AA BB] = sort(G.mu_vec);
        mu_sort = G.mu_vec(BB);    
        mu_cs = cumsum(G.g_vec(BB));
        [CC DD] = min(abs(mu_cs-0.5));
        median_mu = mu_sort(DD);
            
        mean_sigma = G.sigma_vec'*G.g_vec;
        std_sigma = sqrt(((G.sigma_vec-mean_sigma).^2)'*G.g_vec);
        min_sigma = min(G.sigma_vec);
        [AA BB] = sort(G.sigma_vec);
        sigma_sort = G.sigma_vec(BB);    
        sigma_cs = cumsum(G.g_vec(BB));
        [CC DD] = min(abs(sigma_cs-0.5));
        median_sigma = sigma_sort(DD);
            
        out.mean_mu=mean_mu; out.median_mu = median_mu;
        out.std_mu = std_mu; out.min_mu = min_mu;        
        out.mean_sigma=mean_sigma;out.median_sigma=median_sigma;        
        out.std_sigma=std_sigma; out.min_sigma=min_sigma;
        
return